importScripts('https://storage.googleapis.com/workbox-cdn/releases/5.1.2/workbox-sw.js');
const staticCacheName = 'site-static-v2';
const dynamicCacheName = 'site-dynamic-v1';
const assets = [
  '/',
  'index.php',
  'about-sacar.php',
  'audio-category.php',
  'https://www.enableds.com',
  'https://cdn.foxapp.in/sacar/styles/bootstrap.css',
  'https://cdn.foxapp.in/sacar/styles/custom.css',
  'https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700,800,900|Roboto:300,300i,400,400i,500,500i,700,700i,900,900i&display=swap',
  'https://cdn.foxapp.in/sacar/fonts/css/fontawesome-all.min.css',
  'https://cdn.foxapp.in/sacar/app/icons/icon-192x192.png',
  'https://cdn.foxapp.in/sacar/images/sacar-sprite_nav.svg',
  'https://cdn.foxapp.in/sacar/scripts/bootstrap.min.js',
  'https://cdn.foxapp.in/sacar/scripts/custom.js',
  'https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js'
];

self.addEventListener("message", (event) => {
  if (event.data && event.data.type === "SKIP_WAITING") {
    self.skipWaiting();
  }
});

// install event
self.addEventListener('install', evt => {
  //console.log('service worker installed');
  evt.waitUntil(
    caches.open(staticCacheName).then((cache) => {
      console.log('caching shell assets');
      cache.addAll(assets);
    })
  );
});

if (workbox.navigationPreload.isSupported()) {
  workbox.navigationPreload.enable();
}


// activate event
self.addEventListener('activate', evt => {
  //console.log('service worker activated');
  evt.waitUntil(
    caches.keys().then(keys => {
      //console.log(keys);
      return Promise.all(keys
        .filter(key => key !== staticCacheName && key !== dynamicCacheName)
        .map(key => caches.delete(key))
      );
    })
  );
});

// fetch event
self.addEventListener('fetch', evt => {
  //console.log('fetch event', evt);
  evt.respondWith(
    caches.match(evt.request).then(cacheRes => {
      return cacheRes || fetch(evt.request).then(fetchRes => {
        return caches.open(dynamicCacheName).then(cache => {
          cache.put(evt.request.url, fetchRes.clone());
          return fetchRes;
        })
      });
    }).catch(() => caches.match(evt.request.url))
  );
});