<?php include 'config.php'; ?>
<!DOCTYPE HTML>
<html lang="en">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
<title>Aurodarshan</title>
<?php include 'inc/head.php'; ?>
</head>
<body class="theme-light">
<div id="preloader"><div class="spinner-border color-highlight" role="status"></div></div>
<div class="loginpage" id="page">



<div class="page-content">
<div class="page-title page-title-small">
<h2><a href="#" data-back-button><span class="spicon-leftarrow spicon"> </span></a>Sign Up</h2>

</div>
<div class="card header-card shape-rounded" data-card-height="150">
<div class="card-overlay bg-highlight opacity-95"></div>
</div>
<div class="card card-style">
<div class="content mb-0 mt-3 pt-2">
<span class="spicon-logo spicon"> </span>
<h2 class="text-center mt-0 mb-4">Aurodarshan</h2>
<div class="input-style no-borders has-icon validate-field">
<input type="name" class="form-control validate-name" id="name" placeholder="Name">
<label for="form1a" class="color-blue-dark font-10 mt-1">Name</label>
<i class="fa fa-times disabled invalid color-red-dark"></i>
<i class="fa fa-check disabled valid color-green-dark"></i>
<em>(required)</em>
</div>
<div class="input-style no-borders has-icon validate-field mt-2">
<input type="email" class="form-control validate-email" id="email" placeholder="Email">
<label for="form1aa" class="color-blue-dark font-10 mt-1">Email</label>
<i class="fa fa-times disabled invalid color-red-dark"></i>
<i class="fa fa-check disabled valid color-green-dark"></i>
<em>(required)</em>
</div>
<div class="input-style no-borders has-icon validate-field">
<input type="name" class="form-control validate-name" id="phone" minlength="10" maxlength="10" placeholder="Phone">
<label for="form1a" class="color-blue-dark font-10 mt-1">Phone</label>
<i class="fa fa-times disabled invalid color-red-dark"></i>
<i class="fa fa-check disabled valid color-green-dark"></i>
<em>(required)</em>
</div>
<div class="input-style no-borders has-icon validate-field mt-2">
<input type="password" class="form-control validate-password" id="password" placeholder="Choose a Password">
<label for="form3a" class="color-blue-dark font-10 mt-1">Enter a Password</label>
<i class="fa fa-times disabled invalid color-red-dark"></i>
<i class="fa fa-check disabled valid color-green-dark"></i>
<em>(required)</em>
</div>
<div class="input-style no-borders has-icon validate-field mt-2">
<input type="password" class="form-control validate-password" id="cpassword" placeholder="Confirm your Password">
<label for="form3a1" class="color-blue-dark font-10 mt-1">Confirm your Password</label>
<i class="fa fa-times disabled invalid color-red-dark"></i>
<i class="fa fa-check disabled valid color-green-dark"></i>
<em>(required)</em>
</div>

<div class="form-check ">
<input class="font-16 form-check-input" type="checkbox" value="" id="privacy" checked="">
<label class="font-16 form-check-label" for="privacy">I agree <a href="https://www.foxgets.com/privacy-policy" target="_blank">Privacy &amp; Policy</a></label>
</div>

<button type="button" class="btn btn-m btn-full rounded-sm shadow-l bg-green-dark font-900 mt-4 submit" onclick="myFunction()">Create account</button>

<p class="text-center pt-4 pb-4">
<a href="mlogin" class="color-highlight opacity-80 font-12">Already Registered? Sign in Here</a>
</p>

</div>
</div>

</div>

<div id="menu-share" class="menu menu-box-bottom menu-box-detached rounded-m" data-menu-load="menu-share.html" data-menu-height="420" data-menu-effect="menu-over">
</div>
<div id="menu-highlights" class="menu menu-box-bottom menu-box-detached rounded-m" data-menu-load="menu-colors.html" data-menu-height="510" data-menu-effect="menu-over">
</div>
<div id="menu-main" class="menu menu-box-right menu-box-detached rounded-m" data-menu-width="260" data-menu-load="menu-main.html" data-menu-active="nav-pages" data-menu-effect="menu-over">
</div>

<div id="toast-1" class="toast toast-tiny toast-bottom bg-red-dark" data-bs-delay="1000" data-bs-autohide="true"><i class="fa fa-check me-3"></i>Please fill required</div>
<div id="toast-2" class="toast toast-tiny toast-bottom bg-red-dark" data-bs-delay="1000" data-bs-autohide="true"><i class="fa fa-check me-3"></i>Password and Confirm Password not matched</div>
<div id="toast-3" class="toast toast-tiny toast-bottom bg-green-dark" data-bs-delay="1000" data-bs-autohide="true"><i class="fa fa-check me-3"></i>Registered Successfully</div>
<div id="toast-4" class="toast toast-tiny toast-bottom bg-red-dark" data-bs-delay="1000" data-bs-autohide="true"><i class="fa fa-check me-3"></i>Email or Phone Already Exist</div>


</div>
<script type="text/javascript" src="<?=$GIT_DOMAIN_NAME;?>scripts/bootstrap.min.js"></script>
<script type="text/javascript" src="<?=$GIT_DOMAIN_NAME;?>scripts/custom.js"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

<script>
    function myFunction() {
var name = $("#name").val();
var email = $("#email").val();
var phone = $("#phone").val();
var password = $("#password").val();
var cpassword = $("#cpassword").val();
var privacy = $('#privacy').is(':checked') ? "1" : "0";

var toastID = document.getElementById('toast-1');
toastID = new bootstrap.Toast(toastID);
var toastID2 = document.getElementById('toast-2');
toastID2 = new bootstrap.Toast(toastID2);
var toastID3 = document.getElementById('toast-3');
toastID3 = new bootstrap.Toast(toastID3);
var toastID4 = document.getElementById('toast-4');
toastID4 = new bootstrap.Toast(toastID4);


if (name == '' || email == '' || phone == '' || password == '' || cpassword == '' || privacy == '0') {
toastID.show();
} 
else if (password != cpassword ) {
toastID2.show();
} 
else {
$(".submit").html('Please wait ...')
.attr('disabled','disabled');
// AJAX code to submit form.
$.ajax({
type: 'POST',
url: "auth/back/register.php",
data: {name:name,email:email,phone:phone,password:password,cpassword:cpassword},
 cache: false,
success: function(result) {
    if(result=="success"){
        toastID3.show();
        setTimeout(function(){ window.location.href="index"; }, 500);
    }else{
       toastID4.show();  
        $(".submit").html('Create account');
$(".submit").prop('disabled', false);
    }
}
});
}
return false;
}
</script>

</body>
