<?php session_start();
include 'config.php';

$course_id = base64_decode($_GET['course_id']);
?>
<?php include 'inc/sessioninfo.php';?>
<!DOCTYPE HTML>
<html lang="en">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
<title>Aurodarshan</title>
<?php include 'inc/head.php'; ?>
</head>
<body class="theme-light">
<div id="preloader"><div class="spinner-border color-highlight" role="status"></div></div>
<div id="page">

<div class="header header-fixed header-auto-show header-logo-app">

<a href="index" class="header-title">Aurodarshan</a>

<a href="#" data-menu="menu-main" class="header-icon header-icon-2"><span class="spicon-toggle spicon"> </span></a>

</div>

<?php include 'inc/footer.php'; ?>

<div class="page-content" style="min-height:60vh!important">
<div class="page-title page-title-small">
<h2><a href="#" data-back-button><span class="spicon-leftarrow spicon"> </span></a>Courses</h2>
<a href="#" data-menu="menu-main" class="preload-img" >
<span class="spicon-toggle spicon"> </span>
</a>
</div>
<div class="card header-card shape-rounded" data-card-height="150">
<div class="card-overlay bg-highlight opacity-95"></div>
</div>

<div class="card card-style showfetchdata">

</div>


</div>

<?php include 'inc/menu.php'; ?>

<div id="menu-apply" class="menu menu-box-bottom menu-box-detached rounded-m profilemodal " data-menu-height="570" data-menu-effect="menu-over">
<div class="me-3 ms-3 mt-3 pt-3">
<form  id="apply_form"  method="post"  enctype="multipart/form-data">

<input type="hidden" id="course_id" name="course_id">

<div class="input-style has-borders hnoas-icon input-style-always-active validate-field mb-4">
<input type="text" class="form-control validate-name" name="con_name"  id="con_name"  >
<label for="form1" class="color-highlight font-400 font-13">Name</label>
<i class="fa fa-times disabled invalid color-red-dark"></i>
<i class="fa fa-check disabled valid color-green-dark"></i>
<em>(required)</em>
</div>
<div class="input-style has-borders no-icon input-style-always-active validate-field mb-4">
<input type="email" class="form-control validate-email" name="con_email" id="con_email"  >
<label for="form2" class="color-highlight font-400 font-13">Email</label>
<i class="fa fa-times disabled invalid color-red-dark"></i>
<i class="fa fa-check disabled valid color-green-dark"></i>
<em>(required)</em>
</div>
<div class="input-style has-borders no-icon input-style-always-active validate-field mb-4">
<input type="tel" class="form-control validate-tel" name="con_phone" id="con_phone" minlength="10" maxlength="10"  >
<label for="form3" class="color-highlight font-400 font-13">Phone Number</label>
<i class="fa fa-times disabled invalid color-red-dark"></i>
<i class="fa fa-check disabled valid color-green-dark"></i>
<em>(required)</em>
</div>
<div class="input-style has-borders no-icon input-style-always-active validate-field mb-4">
<textarea class="form-control validate-text" name="cont_msg" id="cont_msg" ></textarea>
<label for="form44" class="color-highlight font-400 font-13">Message</label>
<i class="fa fa-times disabled invalid color-red-dark"></i>
<i class="fa fa-check disabled valid color-green-dark"></i>

</div>


<input type="hidden" name="user_id" value="<?=$fetchuserinfo['user_id'];?>">

<button type="submit" class="btn btn-full bg-highlight rounded-sm shadow-xl btn-m  font-900 submit" >Apply</button>
</form>

</div>
</div>


<div id="toast-a1" class="toast toast-tiny toast-bottom bg-red-dark" data-bs-delay="1000" data-bs-autohide="true"><i class="fa fa-check me-3"></i>Please fill required</div>
<div id="toast-a2" class="toast toast-tiny toast-bottom bg-green-dark" data-bs-delay="1000" data-bs-autohide="true"><i class="fa fa-check me-3"></i>Course Applied Successfully</div>

<?php include 'inc/bottom.php'; ?>

<script>
  $(document).ready(function(){

var course_id = <?=$course_id;?>;

var user_id = "<?=$fetchuserinfo['user_id'];?>";

$.ajax({

	url:"backend/fetch-course-detail-info.php",

	method:"POST",

	data:{course_id:course_id,user_id:user_id},

	success:function(data)

	{

		$('.showfetchdata').html(data);

	}

});

});



$(document).on('click','.apply_course',function(){
var course_id = $(this).attr('id');
$('#menu-apply').addClass('menu-active');
$('.menu-hider').addClass('menu-active');
		$('#course_id').val(course_id);
});


//submit
$(document).ready(function(e){
$("#apply_form").on('submit', function(e){

e.preventDefault();

var con_name = $("#con_name").val();
var con_email = $("#con_email").val();
var con_phone = $("#con_phone").val();


var toastID = document.getElementById('toast-a1');
toastID = new bootstrap.Toast(toastID);
var toastID2 = document.getElementById('toast-a2');
toastID2 = new bootstrap.Toast(toastID2);

if (con_name == '' || con_email == '' || con_phone == '') {
toastID.show();

} else {

$(".submit").html('Please wait ...')
.attr('disabled','disabled');
// AJAX code to submit form.
$.ajax({
type: 'POST',
url: "backend/apply-course.php",
data: new FormData(this),

contentType: false,
cache: false,
processData:false,

success: function(result) {
if(result=="success"){
        toastID2.show();
        setTimeout(function(){ window.location.href=""; }, 500);
    }
}
});
}
});
});

</script>


</body>
